within WindPowerPlants.Records.TurbineControlData;

record Heier2009 "Turbine control data of [Heier2009]"
  extends Generic(final p = {0.00212298309850983, -0.10552111636622796, 1.79931615238508824, -8.34638029169715701}, final lambdaMin = 8.98, final lambdaMax = 18.53, final lambdaOpt = 7.87, final betaMin = 0, final betaMax = 90, final betaOpt = 0);
  annotation(Documentation(info = "<html>
<p>Wind turbine control parameters of
[<a href=\"modelica://WindPowerPlants.UsersGuide.References\">Heier2009</a>].
</p></html>"));
end Heier2009;
